<?php

/**
 *
 *    Copyright (C) 2020 onOffice GmbH
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU Affero General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Affero General Public License for more details.
 *
 *    You should have received a copy of the GNU Affero General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

declare(strict_types=1);

namespace onOffice\WPlugin\Installer;

use DI\Container;
use DI\ContainerBuilder;
use onOffice\WPlugin\Controller\RewriteRuleBuilder;
use WP_Rewrite;
use function delete_option;
use const ABSPATH;

/**
 *
 * Creates tables and sets options
 * Also removes them
 *
 */

class Installer
{
	/**
	 * Callback for plugin activation hook
	 */
	static public function install()
	{
		// If you are modifying this, please also make sure to edit the test
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		$pContainer = self::buildDI();
		$pRewriteRuleBuilder = $pContainer->get(RewriteRuleBuilder::class);
		$pRewriteRuleBuilder->addCustomRewriteTags();
		$pRewriteRuleBuilder->addStaticRewriteRules();
		$pRewriteRuleBuilder->addDynamicRewriteRules();
		$pRewriteRuleBuilder->addCustomRewriteTagsForAddressDetail();
		$pRewriteRuleBuilder->addDynamicRewriteRulesForAddressDetail();
		self::flushRules();
	}

	/**
	 * @global WP_Rewrite $wp_rewrite
	 */
	static private function flushRules()
	{
		global $wp_rewrite;
		$wp_rewrite->flush_rules(false);
	}

	/**
	 *
	 */
	static public function deactivate()
	{
		self::flushRules();
	}

	/**
	 * @return Container
	 * @throws \Exception
	 */
	private static function buildDI():Container
	{
		$pDIBuilder = new ContainerBuilder();
		$pDIBuilder->addDefinitions(ONOFFICE_DI_CONFIG_PATH);
		$pDI = $pDIBuilder->build();

		return $pDI;
	}

	/**
	 * @throws \DI\DependencyException
	 * @throws \DI\NotFoundException
	 */
	static public function deinstall()
	{
		$pDI = self::buildDI();
		$pDbChanges = $pDI->get(DatabaseChangesInterface::class);
		$pDbChanges->deinstall();

		// Set autoload to 'no' to prevent the option from being automatically loaded on each page request
		// This ensures the option can be properly deleted 
		update_option('onoffice-notice-cache-was-cleared', true, 'no');

		delete_option('onoffice-default-view');
		delete_option('onoffice-favorization-enableFav');
		delete_option('onoffice-favorization-favButtonLabelFav');
		delete_option('onoffice-maps-mapprovider');
		delete_option('onoffice-settings-apisecret');
		delete_option('onoffice-settings-apikey');
		delete_option('onoffice-detail-view-showTitleUrl');
		delete_option('onoffice-pagination-paginationprovider');
		delete_option('onoffice-duplicate-check-warning');
		delete_option('onoffice-pagination-paginationbyonoffice');
		delete_option('onoffice-settings-captcha-sitekey');
		delete_option('onoffice-settings-google-bot-index-pdf-expose');
		delete_option('onoffice-settings-googlemaps-key');
		delete_option('onoffice-similar-estates-settings-view');
		delete_option('onoffice-is-encryptcredent');
		delete_option('onoffice-settings-default-email');
		delete_option('onoffice-click-button-close-action');
		delete_option('onoffice-settings-title-and-description');
		delete_option('onoffice-settings-honeypot');
		delete_option('onoffice-apply-thousand-separator');
		delete_option('onoffice-settings-opengraph');
		delete_option('onoffice-settings-twittercards');
		delete_option('onoffice-settings-duration-cache');
		delete_option('onoffice-address-detail-view-showInfoUserUrl');
		delete_option('onoffice-settings-captcha-secretkey');
		delete_option('onoffice-notice-cache-was-cleared');
		delete_option('onoffice-settings-thousand-separator');
		delete_option('onoffice-default-address-view');
		

		self::flushRules();
	}
}
