<?php
/**
 *
 *    Copyright (C) 2019 onOffice GmbH
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU Affero General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Affero General Public License for more details.
 *
 *    You should have received a copy of the GNU Affero General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

namespace onOffice\WPlugin\Controller\SortList;

class SortListValidator
{
	/**
	 * @param string $sortBy
	 * @param array $sortbyUserDefinedValues
	 * @return bool
	 */
	public function isSortbyValide(string $sortBy, array $sortbyUserDefinedValues): bool
	{
		return in_array($sortBy, array_keys($sortbyUserDefinedValues));
	}

	/**
	 * @param string $sortorder
	 * @return bool
	 */
	public function isSortorderValide(string $sortorder): bool
	{
		return in_array($sortorder, [SortListTypes::SORTORDER_ASC, SortListTypes::SORTORDER_DESC]);
	}
}