onOffice = onOffice || {};
onOffice.default_values_inputs_converted = onOffice.default_values_inputs_converted || [];

// polyfill
if (window.NodeList && !NodeList.prototype.forEach) {
    NodeList.prototype.forEach = Array.prototype.forEach;
}

onOffice.default_values_input_converter = function () {
    var predefinedValues = onOffice_loc_settings.defaultvalues || {};
    // plaintext
    document.querySelectorAll('select[name=language-language].onoffice-input').forEach(function (element) {
        element.backupLanguageSelection = {};
        var mainInput = element.parentElement.parentElement
            .querySelector('input[name^=oopluginfieldconfigformdefaultsvalues-value].onoffice-input');
        var fieldname = element.parentElement.parentElement.parentElement
            .querySelector('span.menu-item-settings-name').textContent;
        const uniqueFieldname = getUniqueFieldname(element, fieldname);
        if (onOffice.default_values_inputs_converted.indexOf(uniqueFieldname) !== -1) {
            return;
        }
        onOffice.default_values_inputs_converted.push(uniqueFieldname);
        mainInput.name = 'defaultvalue-lang[' + fieldname + '][native]';

        (function () {
            if (predefinedValues[fieldname] !== undefined) {
                var predefinedValuesIsObject = (typeof predefinedValues[fieldname] === 'object') &&
                    !Array.isArray(predefinedValues[fieldname]);
                if (predefinedValuesIsObject) {
                    for (var lang in predefinedValues[fieldname]) {
                        var relevantOption = element.querySelector('option[value=' + lang + ']');
                        if (lang !== 'native') {
                            var clone = generateClone(mainInput, lang);
                            var label = generateLabel(relevantOption.text || '', clone);
                            var deleteButton = generateDeleteButton(element, lang);
                            var paragraph = generateParagraph(label, clone, deleteButton);
                            mainInput.parentNode.parentNode.insertBefore(paragraph, element.parentNode);
                            element.backupLanguageSelection[lang] = relevantOption;
                            element.options[relevantOption.index] = null;
                        }

                        var targetInput = element.parentElement.parentElement.querySelector(
                            'input[name="defaultvalue-lang[' + fieldname + '][' + lang + ']"]');
                        targetInput.value = predefinedValues[fieldname][lang];
                    }
                }
            }
        })();

        element.addEventListener('change', function (event) {
            var value = event.srcElement.value || '';

            if (value !== '') {
                var clone = generateClone(mainInput, value);
                var label = generateLabel(event.srcElement.selectedOptions[0].text, clone);
                var deleteButton = generateDeleteButton(event.srcElement, value);
                var paragraph = generateParagraph(label, clone, deleteButton);

                element.backupLanguageSelection[event.srcElement.selectedOptions[0].value] =
                    event.srcElement.selectedOptions[0];
                event.srcElement.options[event.srcElement.selectedIndex] = null;

                mainInput.parentNode.parentNode.insertBefore(paragraph, event.srcElement.parentNode);
            }
        });

        function generateClone(mainInput, language) {
            var clone = mainInput.cloneNode(true);
            clone.id = 'defaultvalue-lang-' + language;
            clone.name = 'defaultvalue-lang[' + fieldname + '][' + language + ']';
            clone.style.marginLeft = '20px';
            clone.value = '';
            return clone;
        }

        function generateLabel(labelText, clone) {
            var label = document.createElement('label');
            label.classList = ['howto'];
            label.htmlFor = clone.id;
            label.style.minWidth = 'min-content';
            label.textContent = onOffice_loc_settings.label_default_value.replace('%s', labelText);
            return label;
        }

        function generateDeleteButton(srcElement, language) {
            var deleteButton = document.createElement('span');
            deleteButton.id = 'deleteButtonLang-' + language;
            deleteButton.className = 'dashicons dashicons-dismiss deleteButtonLang';
            deleteButton.targetLanguage = language;
            deleteButton.style.display = 'block';
            deleteButton.style.verticalAlign = 'middle';

            deleteButton.addEventListener('click', function (deleteEvent) {
                var restoreValue = element.backupLanguageSelection[deleteEvent.srcElement.targetLanguage];
                srcElement.options.add(restoreValue);
                srcElement.selectedIndex = 0;
                deleteEvent.srcElement.parentElement.remove();
            });
            return deleteButton;
        }

        function generateParagraph(label, clone, deleteButton) {
            var paragraph = document.createElement('p');
            paragraph.classList = ['wp-clearfix custom-input-field custom-label-language'];
            paragraph.appendChild(label);
            paragraph.appendChild(clone);
            paragraph.appendChild(deleteButton);
            return paragraph;
        }
    });

    // single-select, multi-select, boolean
    document.querySelectorAll('select[name^=oopluginfieldconfigformdefaultsvalues-value]')
        .forEach(function (mainInput) {
        var mainElement = mainInput.parentElement.parentElement.querySelector('span.menu-item-settings-name');
        if (mainElement === null) {
            return;
        }

        var fieldName = mainElement.textContent;
        const uniqueFieldname = getUniqueFieldname(mainInput, fieldName);
        if (onOffice.default_values_inputs_converted.indexOf(uniqueFieldname) !== -1) {
            return;
        }
        onOffice.default_values_inputs_converted.push(uniqueFieldname);
        mainInput.name = 'oopluginfieldconfigformdefaultsvalues-value[' + fieldName + ']';
        var predefinedValuesIsArray = (typeof predefinedValues[fieldName] === 'object') &&
            Array.isArray(predefinedValues[fieldName]);

        if (predefinedValuesIsArray) {
            mainInput.value = predefinedValues[fieldName][0];
        }

        var fieldList = onOffice_loc_settings.fieldList || {};
        var fieldDefinition = getFieldDefinition(fieldName);
        for (var module in fieldList) {
            if (fieldList[module][fieldName] !== undefined) {
                fieldDefinition = fieldList[module][fieldName];
            }
        }

        if (fieldDefinition.type === "multiselect") {
            var parent = mainInput.parentElement;
            mainInput.remove();

            var div = document.createElement('div');
            div.setAttribute('data-name', 'oopluginfieldconfigformdefaultsvalues-value[' + fieldName + '][]');
            div.classList.add('multiselect');

            var button = document.createElement('input');
            button.setAttribute('type', 'button');
            button.setAttribute('value', onOffice_loc_settings.field_multiselect_edit_values);
            button.classList.add('onoffice-multiselect-edit');
            div.appendChild(button);

            parent.appendChild(div);

            var multiselectOptions = {
                name_is_array: true,
                cb_class: 'onoffice-input'
            };
            var multiselect = new onOffice.multiselect(div, fieldDefinition.permittedvalues,
                onOffice_loc_settings.defaultvalues[fieldName] || [], multiselectOptions);
            button.onclick = (function(multiselect) {
                return function() {
                    multiselect.show();
                };
            })(multiselect);
        } else if (fieldDefinition.type === "boolean") {
            mainInput.innerHTML = ""; // remove options
            mainInput.options.add(new Option(fieldDefinition.permittedvalues[0], '0'));
            mainInput.options.add(new Option(fieldDefinition.permittedvalues[1], '1'));
            mainInput.selectedIndex = onOffice_loc_settings.defaultvalues[fieldName] || '0';
        }
    });

    // numeric range, int, float
    document.querySelectorAll('input[name^=oopluginfieldconfigformdefaultsvalues-value]').forEach(function (mainInput) {
        var mainElement = mainInput.parentElement.parentElement.querySelector('span.menu-item-settings-name');
        if (mainElement === null) {
            return;
        }
        var fieldName = mainElement.textContent;
        const uniqueFieldname = getUniqueFieldname(mainInput, fieldName);
        if (onOffice.default_values_inputs_converted.indexOf(uniqueFieldname) !== -1 || fieldName === 'dummy_key') {
            return;
        }
        onOffice.default_values_inputs_converted.push(uniqueFieldname);
        
        var fieldDefinition = getFieldDefinition(fieldName);

        if (fieldDefinition.type === "urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:tinyint") {
            const parent = mainInput;
            const element = document.createElement('fieldset');
            const keys = Object.keys(fieldDefinition.permittedvalues).sort();
            parent.name = 'oopluginfieldconfigformdefaultsvalues-value[' + fieldName + ']';

            element.className = 'onoffice-input-radio';
            keys.forEach(k => {
                const mainInputClone = parent.cloneNode(true);
                const label = document.createElement('label');
                onOffice.js_field_count += 1;
                mainInputClone.id = 'input_radio_js_' + onOffice.js_field_count;
                mainInputClone.value = k;
                label.textContent = fieldDefinition.permittedvalues[k];
                if (k == onOffice_loc_settings.defaultvalues[fieldName]) {
                    mainInputClone.checked = true;
                }
                label.appendChild(mainInputClone);
                element.appendChild(label);
                parent.parentElement.appendChild(element);
            });
            const labels = parent.parentElement.getElementsByTagName('label')[1];
            parent.parentElement.removeChild(labels);
            mainInput.remove();
            return;
        }

        if (!fieldDefinition.rangefield &&
            [
                'integer', 'float', 'date', 'datetime',
                'urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:float',
                'urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:int',
                'urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:integer',
                'urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:decimal',
                'urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:date',
                'urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:tinyint'
            ].indexOf(fieldDefinition.type) >= 0) {
            if (fieldDefinition.type === 'date' || fieldDefinition.type === 'urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:date') {
                mainInput.setAttribute('type', 'date');
            }
            if (fieldDefinition.type === 'datetime') {
                mainInput.setAttribute('type', 'datetime-local');
                mainInput.setAttribute('step', 1);
            }
            if ([
                'integer', 'float',
                'urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:float',
                'urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:int',
                'urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:integer',
                'urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:decimal'
            ].indexOf(fieldDefinition.type) >= 0) {
                mainInput.setAttribute('type', 'number');
                mainInput.setAttribute('min', '0');
            }
            mainInput.name = 'oopluginfieldconfigformdefaultsvalues-value[' + fieldName + ']';
            mainInput.value = predefinedValues[fieldName][0] || '';
            return;
        }

        mainInput.name = 'oopluginfieldconfigformdefaultsvalues-value[' + fieldName + '][min]';
        mainInput.type = 'number';
        mainInput.setAttribute('min', '0');
        var mainInputClone = mainInput.cloneNode(true);
        mainInputClone.id = 'input_js_' + onOffice.js_field_count;
        onOffice.js_field_count += 1;
        var labelFrom = mainInput.parentElement.querySelector('label[for='+mainInput.id+']')
        var labelUpTo = labelFrom.cloneNode(true);
        labelUpTo.htmlFor = mainInputClone.id;
        labelFrom.textContent = onOffice_loc_settings.label_default_value_from;
        labelUpTo.textContent = onOffice_loc_settings.label_default_value_up_to;
        mainInputClone.name = 'oopluginfieldconfigformdefaultsvalues-value[' + fieldName + '][max]';
        mainInput.parentElement.appendChild(labelUpTo);
        mainInput.parentElement.appendChild(mainInputClone);
        mainInput.parentElement.classList.add('custom-from-to-input');
        var predefinedValuesIsObject = (typeof predefinedValues[fieldName] === 'object') &&
            !Array.isArray(predefinedValues[fieldName]);

        if (predefinedValuesIsObject) {
            mainInput.value = predefinedValues[fieldName]['min'] || '';
            mainInputClone.value = predefinedValues[fieldName]['max'] || '';
        }

        // Validation for range fields
        var errorElement = document.createElement('div');
        errorElement.className = 'onoffice-range-error';
        errorElement.style.color = 'red';
        errorElement.style.display = 'none';
        errorElement.style.width = '100%';
        errorElement.textContent = onOffice_loc_settings.validation_default_value_range_mismatch;
        mainInputClone.parentElement.appendChild(errorElement);

        function validateRangeFields() {
            var form = mainInput.closest('form');
            if (!form) return true;

            var hasFormError = false;
            var rangeMinInputs = form.querySelectorAll('input[name*="[min]"][type="number"]');

            rangeMinInputs.forEach(function(minInput) {
                var maxInput = minInput.parentElement.querySelector('input[name*="[max]"][type="number"]');
                if (!maxInput) return;

                var minValue = parseFloat(minInput.value) || 0;
                var maxValue = parseFloat(maxInput.value) || 0;
                var hasError = minValue > maxValue && minInput.value !== '' && maxInput.value !== '';
                
                // Show/hide error for this specific range pair
                var errorEl = maxInput.parentElement.querySelector('.onoffice-range-error');
                if (errorEl) {
                    errorEl.style.display = hasError ? 'block' : 'none';
                }
                
                if (hasError) hasFormError = true;
            });

            // Disable submit button on errors
            var submitButtons = form.querySelectorAll('input[type="submit"], button[type="submit"]');
            submitButtons.forEach(function(button) {
                button.disabled = hasFormError;
            });

            return !hasFormError;
        }

        [mainInput, mainInputClone].forEach(function(input) {
            input.addEventListener('input', validateRangeFields);
        });
        validateRangeFields();
    });
};

onOffice.js_field_count = onOffice.js_field_count || 0;

document.addEventListener("addFieldItem", function(e) {
    var fieldName = e.detail.fieldname;
    var p = document.createElement('p');
    p.classList.add('wp-clearfix', 'custom-input-field', 'custom-label-language');
    var fieldDefinition = getFieldDefinition(fieldName);

    if (['varchar', 'text',
        'urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:varchar',
        'urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:Text'].indexOf(fieldDefinition.type) >= 0) {
        var select = document.createElement('select');
        select.id = 'select_js_' + onOffice.js_field_count;
        select.name = 'language-language';
        select.className = 'onoffice-input';

        select.options.add(new Option(onOffice_loc_settings.label_choose_language, ''));
        var keys = Object.keys(onOffice_loc_settings.installed_wp_languages);
        keys.forEach(function (k) {
            var v = onOffice_loc_settings.installed_wp_languages[k];
            if (k === onOffice_loc_settings.language_native) {
                k = 'native';
            }
            select.options.add(new Option(v, k));
        });

        onOffice.js_field_count += 1;
        select.options.selectedIndex = 0;

        var label = document.createElement('label');
        label.htmlFor = select.id;
        label.className = 'howto';
        label.textContent = onOffice_loc_settings.label_add_language;
        p.appendChild(label);
        p.appendChild(select);
    } else if (['singleselect', 'multiselect', 'boolean'].indexOf(fieldDefinition.type) >= 0) {
        var element = e.detail.item.querySelector('input[name^=oopluginfieldconfigformdefaultsvalues-value]');
        var select = document.createElement('select');
        select.id = 'select_js_' + onOffice.js_field_count;
        select.name = 'oopluginfieldconfigformdefaultsvalues-value[]';
        select.className = 'onoffice-input';

        select.options.add(new Option('', ''));
        var keys = Object.keys(fieldDefinition.permittedvalues);
        keys.forEach(function (k) {
            var v = fieldDefinition.permittedvalues[k];
            if (fieldDefinition.labelOnlyValues.indexOf(k) !== -1) {
                var group = document.createElement('optgroup');
                group.label = v;
                select.options.add(group);
            } else {
                select.options.add(new Option(v, k));
                if (k === fieldDefinition.selectedvalue) {
                    select.selectedIndex = select.options.length - 1;
                }
            }
        });

        onOffice.js_field_count += 1;
        select.options.selectedIndex = 0;
        element.parentNode.replaceChild(select, element);
    } else if (['urn:onoffice-de-ns:smart:2.5:dbAccess:dataType:tinyint'].indexOf(fieldDefinition.type) >= 0) {
        const element = e.detail.item.querySelector('input[name^=oopluginfieldconfigformdefaultsvalues-value]');
        const fieldset = document.createElement('fieldset');
        const keys = Object.keys(fieldDefinition.permittedvalues).sort();
        fieldset.className = 'onoffice-input-radio';
        keys.forEach(function (k) {
            const label = document.createElement('label');
            const input = document.createElement('input');
            input.name = 'oopluginfieldconfigformdefaultsvalues-value[' + fieldName + ']';
            input.type = 'radio';
            input.value = k;
            input.className = 'onoffice-input';
            onOffice.js_field_count += 1;
            label.htmlFor = 'input_radio_js_' + onOffice.js_field_count;
            label.textContent = fieldDefinition.permittedvalues[k];
            if(k == onOffice_loc_settings.defaultvalues[fieldName]){
                input.checked = true;
            }
            label.appendChild(input);
            fieldset.appendChild(label);
        });

        element.parentNode.replaceChild(fieldset, element);
    }

    var paragraph = e.detail.item.querySelectorAll('.menu-item-settings p')[2];
    paragraph.parentNode.insertBefore(p, paragraph.nextSibling);
    const uniqueFieldname = getUniqueFieldname(paragraph, fieldName);
    var index = onOffice.default_values_inputs_converted.indexOf(uniqueFieldname);
    if (index !== -1) {
        delete onOffice.default_values_inputs_converted[index];
    }

    onOffice.default_values_input_converter();
});

function getFieldDefinition(fieldName) {
    var fieldList = onOffice_loc_settings.fieldList || {};
    for (var module in fieldList) {
        if (fieldList[module][fieldName] !== undefined) {
            return fieldList[module][fieldName];
        }
    }
    return {};
}

function getUniqueFieldname(mainInput, fieldName) {
    if (document.querySelector('#multi-page-container')) {
        var container = mainInput.closest('#multi-page-container, #single-page-container');
        if (container) {
            return container.id + '-' + fieldName;
        }
    }
    return fieldName;
}

onOffice.default_values_input_converter();